IF EXISTS (select * from sysobjects where name like '%T_Insert_WM_ServidorCliente%')
DROP TRIGGER T_Insert_WM_ServidorCliente
go

CREATE TRIGGER T_Insert_WM_ServidorCliente
ON  WM_ServidorCliente
FOR INSERT, UPDATE
AS

	DECLARE @IdZona DECIMAL(20,0);
	DECLARE @IdZona_Aux DECIMAL(20,0);
	DECLARE Elems_Cursor_IWMSC CURSOR FOR
	SELECT IsNull(IdZona,-1) FROM INSERTED;
	OPEN Elems_Cursor_IWMSC

	FETCH NEXT FROM Elems_Cursor_IWMSC INTO @IdZona
	WHILE @@FETCH_STATUS = 0
	BEGIN	
	
		PRINT 'IdZona ' + CONVERT(VARCHAR(100),@IdZona);

		IF @IdZona != -1
		BEGIN
			--En caso de que el servidor tenga zona vinculada, hacemos la proteccin que la zona sea zona final
			IF (SELECT COUNT(*) FROM WM_Zona WHERE WM_Zona.IdZonaPadre=@IdZona) = 0
			BEGIN
				UPDATE WM_Zona SET TieneServidores=1 WHERE WM_Zona.IdZona=@IdZona
			END
		END

		PRINT 'Ejecucion trigger T_Insert_Servidor.'

	FETCH NEXT FROM Elems_Cursor_IWMSC INTO @IdZona
	END

	CLOSE Elems_Cursor_IWMSC
	DEALLOCATE Elems_Cursor_IWMSC

	--Calculamos para el resto de zonas del sistema que sean zonas finales (no tienen hijos) el valor de TieneServidores
	DECLARE Elems_Cursor_IWMSC2 CURSOR FOR 
	SELECT IdZona FROM WM_Zona WHERE (SELECT COUNT(*) FROM WM_Zona as Zona2 WHERE Zona2.IdZonaPadre=WM_Zona.IdZona) = 0 
	OPEN Elems_Cursor_IWMSC2

	FETCH NEXT FROM Elems_Cursor_IWMSC2 INTO @IdZona_Aux
	WHILE @@FETCH_STATUS = 0
	BEGIN

		--En caso de que la zona tenga servidores vinculados, actualizamos a 1 el valor de TieneServidores, si no a 0
		IF (SELECT COUNT(*) FROM WM_ServidorCliente WHERE IsNull(WM_ServidorCliente.IdZona,-1)=@IdZona_Aux) > 0
		BEGIN
			UPDATE WM_Zona SET TieneServidores=1 WHERE WM_Zona.IdZona=@IdZona_Aux
		END
		ELSE
		BEGIN
			UPDATE WM_Zona SET TieneServidores=0 WHERE WM_Zona.IdZona=@IdZona_Aux
		END
		
	FETCH NEXT FROM Elems_Cursor_IWMSC2 INTO @IdZona_Aux
	END

	CLOSE Elems_Cursor_IWMSC2
	DEALLOCATE Elems_Cursor_IWMSC2

GO
ALTER TABLE WM_ServidorCliente ENABLE TRIGGER T_Insert_WM_ServidorCliente
GO